//OHSAT GAMES MEGATILER TUTORIAL - TILE MOVEMENT (Part 2)- https://www.ohsat.com/tutorial/megatiler/megatiler-4/
//MEGATEAMWORK Makes the MEGADREAM Work 
//SGDK Version: 2.0 

//https://www.ohsat.com/tutorial/#mega-drive-tutorials 

#include <genesis.h>
#include <resources.h>
 
//array defines for tile usage

#define SOLID_TILE 1    // barrier tile
#define SPAWN_TILE 4    // value for player sprite for use in array

//tile measurement defines

#define TILESIZE 8      // pixel value tile size
#define MAP_WIDTH 8     // tile width
#define MAP_HEIGHT 8    // tile height

//Sprite animation defines

#define ANIM_DOWN 0
#define ANIM_UP 1
#define ANIM_SIDE 2

// 4 is player sprite, 0 is grass tile, 1 is wall tile.
u8 level1[8][8] = {
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 1, 0, 0, 0},
    {0, 0, 0, 1, 1, 0, 0, 0},
    {4, 0, 0, 0, 1, 0, 0, 0},
    {0, 0, 0, 0, 1, 0, 0, 0},
    {0, 0, 0, 0, 1, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0}
};

u8 x = 0;
u8 y = 0;
u8 t = 0;

// --- FIX: Forward declaration added ---
int getTileAt(u8 X, u8 Y);

typedef struct {
    u8 x;
    u8 y; 
} Point;

typedef enum { up, down, left, right, none } moveDirection;

typedef struct {
    Point pos;
    Point tilePos;
    int w; 
    int h;
    int health;
    bool moving;
    moveDirection dir;
    Sprite *sprite;
    char name[6];
} Entity;

Entity player = {{0, 0}, {0, 0}, 8, 8, 0, FALSE, none, NULL, "PLAYER"};

void loadLevel();
void movePlayer(moveDirection Direction);
void myJoyHandler(u16 joy, u16 changed, u16 state);

int main()
{   
    JOY_init();
    JOY_setEventHandler(&myJoyHandler);
    loadLevel();
   
    while(1)
    {
        if(player.moving == TRUE){
        switch(player.dir){
            case up:
                player.pos.y -= 1;
                break;

            case down: 
                player.pos.y += 1;
                break;

            case left: 
                player.pos.x -= 1;
                break;

            case right: 
                player.pos.x += 1;
                break;

                break;
            default:
                break;
            }
        }

        SPR_update(); 

        if (player.pos.x % TILESIZE == 0 && player.pos.y % TILESIZE == 0)
        {
            player.moving = FALSE;
        }
        
        SPR_setPosition(player.sprite, player.pos.x, player.pos.y);
        SYS_doVBlankProcess();
    }

    return 0;
}

// --- FIXED TILE ACCESS ---
int getTileAt(u8 X, u8 Y)
{
    // Safer way: direct access
    return level1[Y][X];
}

void loadLevel()
{
    SPR_init();

    for (y = 0; y < MAP_HEIGHT; y++) {
        for (x = 0; x < MAP_WIDTH; x++) {
            t = level1[y][x];

            if (t == SPAWN_TILE)
            {
                player.tilePos.x = x;
                player.tilePos.y = y;

                player.pos.x = x * TILESIZE;
                player.pos.y = y * TILESIZE;

                player.sprite = SPR_addSprite(
                    &spr_player,
                    player.pos.x,
                    player.pos.y,
                    TILE_ATTR(PAL2, 0, FALSE, FALSE)
                );

                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), x, y);
            }
            else {
                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, t + 1), x, y);
            }
        }
    }

    VDP_loadTileSet(floortiles.tileset, 1, DMA);
    PAL_setPalette(PAL1, floortiles.palette->data, DMA);
    PAL_setPalette(PAL2, spr_player.palette->data, DMA);
}

void movePlayer(moveDirection Direction)
{
    if (!player.moving)
    {
        switch(Direction)
        {
            case up:
                if (player.tilePos.y > 0 &&
                    getTileAt(player.tilePos.x, player.tilePos.y - 1) != SOLID_TILE)
                {
                    player.tilePos.y--;
                    player.moving = TRUE;
                    player.dir = Direction;
                    SPR_setAnim(player.sprite, ANIM_UP);
                }
                break;

            case down:
                if (player.tilePos.y < MAP_HEIGHT - 1 &&
                    getTileAt(player.tilePos.x, player.tilePos.y + 1) != SOLID_TILE)
                {
                    player.tilePos.y++;
                    player.moving = TRUE;
                    player.dir = Direction;
                    SPR_setAnim(player.sprite, ANIM_DOWN);
                }
                break;

            case left:
                if (player.tilePos.x > 0 &&
                    getTileAt(player.tilePos.x - 1, player.tilePos.y) != SOLID_TILE)
                {
                    player.tilePos.x--;
                    player.moving = TRUE;
                    player.dir = Direction;
                    SPR_setAnim(player.sprite, ANIM_SIDE);
                    SPR_setHFlip(player.sprite, TRUE);
                }
                break;

            case right:
                if (player.tilePos.x < MAP_WIDTH - 1 &&
                    getTileAt(player.tilePos.x + 1, player.tilePos.y) != SOLID_TILE)
                {
                    player.tilePos.x++;
                    player.moving = TRUE;
                    player.dir = Direction;
                    SPR_setAnim(player.sprite, ANIM_SIDE);
                    SPR_setHFlip(player.sprite,FALSE);
                }
                break;

            default:
                break;
        }
    }
}

void myJoyHandler(u16 joy, u16 changed, u16 state)
{
    if (joy == JOY_1)
    {
        if (state & BUTTON_UP)
            movePlayer(up);
        else if (state & BUTTON_DOWN)
            movePlayer(down);
        else if (state & BUTTON_LEFT)
            movePlayer(left);
        else if (state & BUTTON_RIGHT)
            movePlayer(right);
    }
}


////////////////////NOTES////////////////////

/*

1. Using an if() statement that contains a switch case statements for movement. 
It's going to start like this. 

while(1){
    if(player.moving == TRUE){
    //case statement
    }
}

OHSAT has us put these in the while(1) loop at the beginning
of the tutorial. This information may get moved later. 

The case statement we're using is set up like this to start. 

switch(player.dir){
case up:
    //Move up
    break;

case down: 
    //Move down
    break;

case left: 
    //Move left
    break;

case right: 
    //Move right
    break;

    break;
default:
    break;
}

Within those cases, we need to tell the screen to shift the x or y position depending on what direction is pressed. 
I suspect this will get modified at some point to take into configuration gravity and velocity but baby-steps. 

Here's what the switch cases look like when using player.pos values for x and y 

switch(player.dir){
case up:
    player.pos.y -= 1;
    break;

case down: 
    player.pos.y += 1;
    break;

case left: 
    player.pos.x -= 1;
    break;

case right: 
    player.pos.x += 1;
    break:

    break;
default:
    break;
}

2. Setting the sprite position in the while(1) loop so that pressing a direction
on the controller moves the sprite on the screen using SPR_setPosition() function

We're currently using integers not fix32 values so no current need for fixToInt() conversions...yet.
We'll see what Andrej/OHSAT has in store for us later. 

Here's what the while() loop looks like currently. 

    while(1)
    {
        if(player.moving == TRUE){
        switch(player.dir){
            case up:
                player.pos.y -= 1;
                break;

            case down: 
                player.pos.y += 1;
                break;

            case left: 
                player.pos.x -= 1;
                break;

            case right: 
                player.pos.x += 1;
                break;

                break;
            default:
                break;
            }
        }
        
        SPR_update(); 
        SPR_setPosition(player.sprite, player.pos.x, player.pos.y);
        SYS_doVBlankProcess();
    }

After doing a Save/Clean/Compile, the directions should respond. Well, whichever direction you press 
first will respond and then your character is moving across the screen like it's Disney on ice...endlessly.

3. We're going to put code in there to make sure the player actually stops. we'll put another if() statement
below the switch statement we wrote earlier but above the SPR_setPosition() function. 

This is the if() statement we're going to use. 

if (player.pos.x % TILESIZE == 0 && player.pos.y % TILESIZE == 0){
    //Stop the player
}

The modulus operator % comes in really handy here. 
We have specified a fixed TILESIZE for our tilemap, which, in our case, is 8. 
As we want strictly tile-based movement, this means that we only want to move our player in steps of 8 pixels, 
because that is always the distance to the next tile over. 
As our player is currently moving at 1 pixel per frame, we have to stop it once it has moved 8 pixels. 
We could either simply count the amount of total pixels moved and stop the player then; 
or we can be fancy and use the modulus operator, which returns the remainder of a division. 
When this remainder is 0, it means that the current position of the player is a multiple of 8…and therefore 
the position of a tile, which is exactly where we want the player to be.

Now, we simply need to tell the player to stop moving with player.moving = FALSE. 

if (player.pos.x % TILESIZE == 0 && player.pos.y % TILESIZE == 0){
    player.moving = FALSE;
}

4. Assign sprite animations in movePlayer() function

List of #define(s) for sprite animations

#define ANIM_DOWN 0
#define ANIM_UP 1
#define ANIM_SIDE 2

Next we use the SPR_setAnim() function to assign animations to the directions

UP is the following:

player.dir = Direction;
SPR_setAnim(player.sprite, ANIM_UP);

DOWN is the following: 
player.dir = Direction;
SPR_setAnim(player.sprite, ANIM_DOWN);

For left and right movement we'll use a similar statement structure but also
we need to include a SPR_setHFlip() function to swap the sprite around so it faces the
correct direction. 

LEFT is the following:

SPR_setAnim(player.sprite, ANIM_SIDE);
SPR_setHFlip(player.sprite, TRUE);

RIGHT is the following:

SPR_setAnim(player.sprite, ANIM_SIDE);
SPR_setHFlip(player.sprite, FALSE);

At this point, the player sprite is now moving around the map, SOLID_TILE acts as a collision tile,
the sprite faces the correct direction on the input press, and SPAWN_TILE player sprite can't escape
the boundaries of the map we've defined. 

*/

/////////EXPERIMENTATION IDEAS///////////////

/*

If you want to be creative you can create a palette swap of the player sprite and see if you can 
add a second player. 

*/

///////////ERROR HANDLING////////////////////

/*


*/